<?php
class Contact extends User {	
	const STATUS_OFFLINE = 0;
	const STATUS_ONLINE = 1;
	
	public function __construct($id, $alias = null){
		parent::__construct($id);
		if(!empty($alias)) $this->info['nick'] = $alias;
	}
	
  public function get_info($login_info = false){
  	// get basic information
  	$info = parent::get_info($login_info);
  	
  	// get status
  	$sessions = $this->db->select(array(), array('sessions'), array(array('id_user')), array('goperator' => 'and', array('id_user', '=', $this->id), array('logout_time', 'IS', 'NULL')));
  	$info['status'] = (empty($sessions)) ? self::STATUS_OFFLINE : self::STATUS_ONLINE;
  	return $info;
  }
}
?>